{$keep 'Foundation'}

unit Foundation;

interface

{*********************************************************
*
*  Foundation Editor Interface File
*
*  Other Uses Files Needed:  Common
*
*  Copyright Lunar Productions, 1991, 1992
*  All Rights Reserved
*
*  last revised:  17Jul92   MTC
*
**********************************************************}

uses
   Common, WindowMgr;

const
    F_UNDO        = $0001;
    F_CLIP        = $0002;
    F_CLEAR       = $0004;
    F_PRINT       = $0008;
    F_SELECT      = $0010;
    F_HELPAPPLY   = $0040;
    F_MENUAPPLY   = $0080;
    F_OPENSILENT  = $0100;
    F_OPENDATA    = $0200;
    F_REMSELECTOR = $0400;
    F_HEXEDIT     = $0800;
    F_SCRIPTEDIT  = $1000;
    F_PAGESETUP   = $2000;
    F_640MODE     = $4000;
    F_ACTIVATE    = $8000;

type
    rgnList = record
	    index :	integer;
	    count : integer;
	    list :  array [1..32] of handle;
	    end;

    rgnListPtr = ^rgnList;
    rgnListHand = ^rgnListPtr;

   replyRecord5_0 = record
       good:         boolean;
       fileType:     integer;
       auxFileType:  longint;
       nameVerb:     integer;
       nameRef:      longint;
       pathVerb:     integer;
       pathRef:      longint;
       end;

   typeRec = record
       flags:     integer;
       fileType:  integer;
       auxType:   longint;
       end;

   typeList5_0 = record
       numEntries:       integer;
       fileAndAuxTypes:  array [1..10] of typeRec;     (* change array size *)
       end;                                            (*   as needed       *)
   typeList5_0Ptr = ^typeList5_0;


{
    The following structures are defined for the Foundation REM entry blocks
    ------------------------------------------------------------------------

    REM_OPEN
}
    fOpenRec = record
        resType:        integer;
        resID:          longint;
        fFlag:          integer;
        Data:           handle;
        wColor:         wColorPtr;
        end;

    fOpenRecPtr = ^fOpenRec;

{
    REM_CLOSE
    REM_WRITE
    REM_PRINT
}
    fCloseRec = record
        resType:        integer;
        resID:          longint;
        fFlag:          integer;
        windowPtr:      grafPortPtr;
        end;

    fCloseRecPtr = ^fCloseRec;

{
    REM_EVENT
}
    fEventRec = record
        resType:        integer;
        resID:          longint;
        fFlag:          integer;
        taskCode:       integer;
        end;

    fEventRecPtr = ^fEventRec;

{
    REM_ACTIVATE
}
    fActivateRec = record
        resType:        integer;
        resID:          longint;
        fFlag:          integer;
        linkHand:       handle;
        end;

    fActivateRecPtr = ^fActivateRec;

{
    REM_GETLINK
}
    fLinkRec = record
        resType:        integer;
        resID:          longint;
        resFileID:      integer;
        linkHand:       handle;
        end;

    fLinkRecPtr = ^fLinkRec;

{
    REM_VIDMODE
}
    fVidModeRec = record
        resType:        integer;
        resID:          longint;
        fFlag:          integer;
        windowPtr:      grafPortPtr;
        wColor:         wColorPtr;
        end;

    fVidModeRecPtr = ^fVidModeRec;

{
    REM_STARTUP
    REM_SHUTDOWN
}
    fStartStopRec = record
        edUserID:       integer;
        edResFileID:    integer;
        shResFileID:    integer;
        fdResFileID:    integer;
        end;

    fStartStopRecPtr = ^fStartStopRec;

{  Shell Callback Parameter Blocks }

{
    fColorPalette
}

    fColorRec = record
        pcount:         integer;
        loc:            Point;
        color:          integer;
        end;

    fColorRecPtr = ^fColorRec;

{
    fLoadFileData
}

    fLoadFileRec = record
        pCount:               integer;
        fileData:             handle;
        sfGet2ReplyRecPtr:    ^replyRecord5_0;
        sfGet2PromptRefPtr:   pStringPtr;
        sfGet2FileTypeRecPtr: ^typeList5_0;
        sfGet2FilterProcPtr:  ptr;
        end;

    fLoadFileRecPtr = ^fLoadFileRec;

{
    fMarquee
}

    fMarqueeRec = record
        pcount:         integer;
        action:         integer;
        windowPtr:      ptr;
        rgnListHndl:    rgnListHand;
        end;

    fMarqueeRecPtr = ^fMarqueeRec;

{
    fAddPrivateData
    fGetPrivateData
    fRelPrivateData
    fSetPrivateData
}

    fPrivateDataRec = record
        pcount:         integer;
        winPtr:         ptr;
        remTaskMask:    longint;
        remSignature:   integer;
        Data:           handle;
        groupSignature: integer;
        resType:        integer;
        resID:          longint;
        end;

    fPrivateDataRecPtr = ^fPrivateDataRec;

{
    fResourceConverter
}

    fResConverterRec = record
        pcount:         integer;
        resType:        integer;
        converterProc:  longint;
        logFlags:       integer;
        end;

    fResConverterRecPtr = ^fResConverterRec;

{
    fCopyResource
}

    fResCopyRec = record
        pcount:         integer;
        resType:        integer;
        resID:          longint;
        newID:          longint;
        attr:           integer;
        resFileID:      integer;
        newFileID:      integer;
        newName:        pStringPtr;
        end;

    fResCopyRecPtr = ^fResCopyRec;

{
    fAddResource
    fGetResourceAttr
    fLoadResource
    fLoadScrap
    fRequestEdit
    fSaveScrap
    fSelectorMenu
    fSelectorRequest
    fSetResourceAttr
    fSpecialMagic
}
    fResDataRec = record
        pCount:         integer;
        resType:        integer;
        resID:          longint;
        resData:        handle;
        special:        integer;
        resFileID:      integer;
        resName:        ptr;
        end;

    fResDataRecPtr = ^fResDataRec;

{
    fCountResources
    fGetEditorStatus
    fGetIndResource
    fGetResourceSize
    fSetResourceID
}

    fResData2Rec = record
        pCount:         integer;
        resType:        integer;
        resID:          longint;
        result:         longint;
        resFileID:      integer;
        end;

    fResData2RecPtr = ^fResData2Rec;

{
    fBuildLinkHand
    fDisposeLinkHand
    fExtendLinkHand
    fFindHostLink
    fQueryLinkHand
}

    fResLinkRec = record
        pCount:         integer;
        index:          integer;
        linkHand:       handle;
        hostType:       integer;
        hostID:         longint;
        resType:        integer;
        resID:          longint;
        resCheck:       integer;
        resFileID:      integer;
        end;

    fResLinkRecPtr = ^fResLinkRec;

{
    fGetResourceName
    fGetStdTypeName
    fGetWindowTitle
    fSetResourceName
}

    fResNameRec = record
        pCount:         integer;
        resType:        integer;
        resID:          longint;
        resName:        pStringPtr;
        end;

    fResNameRecPtr = ^fResNameRec;

{
    fDetachResource
    fReleaseResource
    fRemoveResource
    fUniqueResourceID
    fWriteResource
}
    fResRefRec = record
        pCount:         integer;
        resType:        integer;
        resID:          longint;
        resFileID:      integer;
        end;

    fResRefRecPtr = ^fResRefRec;

{
    fGetKernalID
    fSpinCursor     use no parameter blocks
}

{ The Shell Callbacks }

function fAddPrivateData (P : fPrivateDataRecPtr) : integer;     external;
function fAddResource (P : fResDataRecPtr) : integer;            external;
function fBuildLinkHand (P : fResLinkRecPtr) : integer;          external;
function fColorPalette (P : fColorRecPtr) : integer;             external;
function fCopyResource (P : fResCopyRecPtr) : integer;           external;
function fCountResources (P : fResData2RecPtr) : integer;        external;
function fDetachResource (P : fResRefRecPtr) : integer;          external;
function fDisposeLinkHand (P : fResLinkRecPtr) : integer;        external;
function fExtendLinkHand (P : fResLinkRecPtr) : integer;         external;
function fFindHostLink (P : fResLinkRecPtr) : integer;           external;
function fGetEditorStatus (P : fResData2RecPtr) : integer;       external;
function fGetIndResource (P : fResData2RecPtr) : integer;        external;
function fGetKernalID: integer;                                  external;
function fGetPrivateData (P : fPrivateDataRecPtr) : integer;     external;
function fGetResourceAttr (P : fResDataRecPtr) : integer;        external;
function fGetResourceName (P : fResNameRecPtr) : integer;        external;
function fGetResourceSize (P : fResData2RecPtr) : integer;       external;
function fGetStdTypeName (P : fResNameRecPtr) : integer;         external;
function fGetWindowTitle (P : fResNameRecPtr) : integer;         external;
function fLoadFileData (P : fLoadFileRecPtr) : integer;          external;
function fLoadResource (P : fResDataRecPtr) : integer;           external;
function fLoadScrap (P : fResDataRecPtr) : integer;              external;
function fMarquee (P : fMarqueeRecPtr) : integer;                external;
function fQueryLinkHand (P : fResLinkRecPtr) : integer;          external;
function fRelPrivateData (P : fPrivateDataRecPtr) : integer;     external;
function fReleaseResource (P : fResRefRecPtr) : integer;         external;
function fRemoveResource (P : fResRefRecPtr) : integer;          external;
function fRequestEdit (P : fResDataRecPtr) : integer;            external;
function fResourceConverter (P : fResConverterRecPtr) : integer; external;
function fSaveScrap (P : fResDataRecPtr) : integer;              external;
function fSelectorMenu (P : fResDataRecPtr) : integer;           external;
function fSelectorRequest (P : fResDataRecPtr) : integer;        external;
function fSetPrivateData (P : fPrivateDataRecPtr) : integer;     external;
function fSetResourceAttr (P : fResDataRecPtr) : integer;        external;
function fSetResourceID (P : fResData2RecPtr) : integer;         external;
function fSetResourceName (P : fResNameRecPtr) : integer;        external;
function fSpecialMagic (P : fResDataRecPtr) : integer;           external;
function fSpinCursor: integer;                                   external;
function fUniqueResourceID (P : fResRefRecPtr) : integer;        external;
function fWriteResource (P : fResRefRecPtr) : integer;           external;

implementation

end.
